DROP TABLE IF EXISTS `export_schemes`;
CREATE TABLE `export_schemes` (
	`scheme_id` int(11) unsigned NOT NULL AUTO_INCREMENT,
	`type_id` int(11) unsigned NOT NULL DEFAULT '2',
	`scheme_name` varchar(255) NOT NULL DEFAULT '',
	`filename` varchar(45) NOT NULL DEFAULT '',
	`field_separator` varchar(8) NOT NULL DEFAULT '',
	`field_quotes` varchar(8) NOT NULL DEFAULT '',
	`date_created` datetime NOT NULL DEFAULT '1000-01-01 00:00:00',
	`date_modified` timestamp NOT NULL ON UPDATE CURRENT_TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
	`date_last_export` datetime NOT NULL DEFAULT '1000-01-01 00:00:00',
	`created_by` varchar(45) NOT NULL DEFAULT 'custom',
	`customers_status_id` int(11) unsigned NOT NULL DEFAULT '0',
	`currencies_id` int(11) unsigned NOT NULL DEFAULT '0',
	`languages_id` int(11) unsigned NOT NULL DEFAULT '0',
	`campaign_id` varchar(64) NOT NULL DEFAULT '',
	`shipping_free_minimum` decimal(15,4) NOT NULL DEFAULT '0.0000',
	`quantity_minimum` decimal(15,4) NOT NULL DEFAULT '0.0000',
	`export_attributes` tinyint(1) NOT NULL DEFAULT '0',
	`export_properties` tinyint(1) NOT NULL DEFAULT '0',
	`export_features` tinyint(1) NOT NULL DEFAULT '0',
	`cronjob_allowed` tinyint(1) NOT NULL DEFAULT '0',
	`cronjob_days` varchar(32) NOT NULL DEFAULT 'Mon|Tue|Wed|Thu|Fri|Sat|Sun',
	`cronjob_hour` enum('0','1','2','3','4','5','6','7','8','9','10','11','12','13','14','15','16','17','18','19','20','21','22','23') NOT NULL DEFAULT '3',
	`cronjob_interval` enum('0','1','2','3','4','5','6','7','8','9','10','11','12') NOT NULL DEFAULT '0',
	`export_all_new_ones` tinyint(1) NOT NULL DEFAULT '0',
	`export_property_image` tinyint(1) NOT NULL DEFAULT '0',
	`amount_additional_image_files` INT NOT NULL DEFAULT '99999',
	PRIMARY KEY (`scheme_id`),
	UNIQUE KEY `scheme_type` (`type_id`,`scheme_name`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

INSERT INTO `export_schemes` (`scheme_id`, `type_id`, `scheme_name`, `filename`, `field_separator`, `field_quotes`, `date_created`, `date_modified`, `date_last_export`, `created_by`, `customers_status_id`, `currencies_id`, `languages_id`, `campaign_id`, `shipping_free_minimum`, `quantity_minimum`, `export_attributes`, `export_properties`, `export_features`, `cronjob_allowed`, `cronjob_days`, `cronjob_hour`, `cronjob_interval`, `export_all_new_ones`, `export_property_image`, `amount_additional_image_files`) VALUES
	(1, 3, '[Gambio] Google Shopping', 'google_shopping_feed.txt', '\\t', '', '2013-05-11 12:52:03', '2017-09-27 10:30:00', '1000-01-01 00:00:00', 'gambio', 1, 1, 2, '0', '0.0000', '0.0000', 0, 0, 0, 0, 'Mon|Tue|Wed|Thu|Fri|Sat|Sun', '3', '0', 0, 0, 10),
	(2, 2, '[Gambio] Billiger.de', 'billiger.csv', '|', '', '2013-05-11 12:52:03', '2017-09-27 10:30:00', '1000-01-01 00:00:00', 'gambio', 1, 1, 2, '0', '0.0000', '0.0000', 0, 0, 0, 0, 'Mon|Tue|Wed|Thu|Fri|Sat|Sun', '3', '0', 0, 0, 99999),
	(3, 2, '[Gambio] Idealo.de', 'idealo.csv', '\\t', '', '2013-05-11 12:52:03', '2017-09-27 10:30:00', '1000-01-01 00:00:00', 'gambio', 1, 1, 2, '0', '0.0000', '0.0000', 0, 0, 0, 0, 'Mon|Tue|Wed|Thu|Fri|Sat|Sun', '3', '0', 0, 0, 99999),
	(4, 2, '[Gambio] Preisroboter.de', 'preisroboter.txt', '|', '', '2013-05-11 12:52:03', '2017-09-27 10:30:00', '1000-01-01 00:00:00', 'gambio', 1, 1, 2, '0', '0.0000', '0.0000', 0, 0, 0, 0, 'Mon|Tue|Wed|Thu|Fri|Sat|Sun', '3', '0', 0, 0, 99999),
	(5, 1, '[Gambio] Artikelexport', 'artikelexport.csv', '|', '"', '2013-05-29 12:52:03', '2013-05-29 12:48:29', '1000-01-01 00:00:00', 'gambio', 0, 0, 2, '0', '0.0000', '0.0000', 0, 0, 0, 0, 'Mon|Tue|Wed|Thu|Fri|Sat|Sun', '3', '0', 0, 0, 99999),
	(6, 2, '[Gambio] Ciao.de', 'ciao.csv', '|', '"', '2013-05-29 12:52:03', '2017-09-27 10:30:00', '1000-01-01 00:00:00', 'gambio', 1, 1, 2, '0', '0.0000', '0.0000', 0, 0, 0, 0, 'Mon|Tue|Wed|Thu|Fri|Sat|Sun', '3', '0', 0, 0, 99999),
	(7, 2, '[Gambio] Geizhals.at', 'geizhals.csv', ';', '"', '2013-05-30 11:16:15', '2017-09-27 10:30:00', '1000-01-01 00:00:00', 'gambio', 1, 1, 2, '0', '0.0000', '0.0000', 0, 0, 0, 0, 'Mon|Tue|Wed|Thu|Fri|Sat|Sun', '3', '0', 0, 0, 99999),
	(8, 2, '[Gambio] Guenstiger.de', 'guenstiger.csv', '|', '', '2013-05-30 13:51:21', '2017-09-27 10:30:00', '1000-01-01 00:00:00', 'gambio', 1, 1, 2, '0', '0.0000', '0.0000', 0, 0, 0, 0, 'Mon|Tue|Wed|Thu|Fri|Sat|Sun', '3', '0', 0, 0, 99999),
	(9, 2, '[Gambio] Become.eu', 'become.txt', '|', '"', '2013-05-30 14:29:44', '2017-09-27 10:30:00', '1000-01-01 00:00:00', 'gambio', 1, 1, 2, '0', '0.0000', '0.0000', 0, 0, 0, 0, 'Mon|Tue|Wed|Thu|Fri|Sat|Sun', '3', '0', 0, 0, 99999),
	(10, 2, '[Gambio] Preissuchmaschine.de', 'preissuchmaschine.csv', '|', '', '2013-05-30 14:50:20', '2017-09-27 10:30:00', '1000-01-01 00:00:00', 'gambio', 1, 1, 2, '0', '0.0000', '0.0000', 0, 0, 0, 0, 'Mon|Tue|Wed|Thu|Fri|Sat|Sun', '3', '0', 0, 0, 99999),
	(11, 2, '[Gambio] Carmio.de', 'carmio.csv', ';', '"', '2013-05-30 16:05:42', '2017-09-27 10:30:00', '1000-01-01 00:00:00', 'gambio', 1, 1, 2, '0', '0.0000', '0.0000', 0, 0, 0, 0, 'Mon|Tue|Wed|Thu|Fri|Sat|Sun', '3', '0', 0, 0, 99999),
	(12, 2, '[Gambio] Nextag.de', 'nextag.csv', ';', '"', '2013-05-30 20:51:29', '2017-09-27 10:30:00', '1000-01-01 00:00:00', 'gambio', 1, 1, 2, '0', '0.0000', '0.0000', 0, 0, 0, 0, 'Mon|Tue|Wed|Thu|Fri|Sat|Sun', '3', '0', 0, 0, 99999),
	(13, 2, '[Gambio] Smatch.com', 'smatch.csv', ';', '"', '2013-05-31 11:12:22', '2017-09-27 10:30:00', '1000-01-01 00:00:00', 'gambio', 1, 1, 2, '0', '0.0000', '0.0000', 0, 0, 0, 0, 'Mon|Tue|Wed|Thu|Fri|Sat|Sun', '3', '0', 0, 0, 99999),
	(14, 2, '[Gambio] Preis.de', 'preis.csv', ';', '"', '2013-06-03 12:50:05', '2017-09-27 10:30:00', '1000-01-01 00:00:00', 'gambio', 1, 1, 2, '0', '0.0000', '0.0000', 0, 0, 0, 0, 'Mon|Tue|Wed|Thu|Fri|Sat|Sun', '3', '0', 0, 0, 99999),
	(15, 2, '[Gambio] LeGuide.com', 'leguide.csv', '|', '', '2013-07-23 15:18:09', '2017-09-27 10:30:00', '1000-01-01 00:00:00', 'gambio', 1, 1, 2, '0', '0.0000', '0.0000', 0, 0, 0, 0, 'Mon|Tue|Wed|Thu|Fri|Sat|Sun', '3', '0', 0, 0, 99999),
	(16, 2, '[Gambio] Preisvergleich.de', 'preisvergleich.txt', ';', '', '2013-07-23 14:34:32', '2017-09-27 10:30:00', '1000-01-01 00:00:00', 'gambio', 1, 1, 2, '0', '0.0000', '0.0000', 0, 0, 0, 0, 'Mon|Tue|Wed|Thu|Fri|Sat|Sun', '3', '0', 0, 0, 99999),
	(17, 2, '[Gambio] Shopzilla.de', 'shopzilla.csv', ';', '"', '2013-07-23 16:46:08', '2017-09-27 10:30:00', '1000-01-01 00:00:00', 'gambio', 1, 1, 2, '0', '0.0000', '0.0000', 0, 0, 0, 0, 'Mon|Tue|Wed|Thu|Fri|Sat|Sun', '3', '0', 0, 0, 99999),
	(18, 2, '[Gambio] Zentralverkauf.de', 'zentralverkauf.csv', '|', '', '2013-07-23 14:34:32', '2017-09-27 10:30:00', '1000-01-01 00:00:00', 'gambio', 1, 1, 2, '0', '0.0000', '0.0000', 0, 0, 0, 0, 'Mon|Tue|Wed|Thu|Fri|Sat|Sun', '3', '0', 0, 0, 99999),
	(19, 2, '[Gambio] Geizkragen.de', 'geizkragen.csv', ';', '', '2013-07-23 20:01:32', '2017-09-27 10:30:00', '1000-01-01 00:00:00', 'gambio', 1, 1, 2, '0', '0.0000', '0.0000', 0, 0, 0, 0, 'Mon|Tue|Wed|Thu|Fri|Sat|Sun', '3', '0', 0, 0, 99999);

INSERT INTO `export_schemes` (`scheme_id`, `type_id`, `scheme_name`, `filename`, `field_separator`, `field_quotes`, `date_created`, `date_modified`, `date_last_export`, `created_by`, `customers_status_id`, `currencies_id`, `languages_id`, `campaign_id`, `shipping_free_minimum`, `quantity_minimum`, `export_attributes`, `export_properties`, `export_features`, `cronjob_allowed`, `cronjob_days`, `cronjob_hour`, `cronjob_interval`, `export_all_new_ones`, `export_property_image`, `amount_additional_image_files`) VALUES (20, 2, '[Gambio] Daparto.de', 'daparto.csv', ';', '''', '2013-07-24 12:43:38', '2013-07-24 12:43:38', '1000-01-01 00:00:00', 'gambio', 1, 1, 2, '0', 0.0000, 0.0000, 0, 0, 0, 0, 'Mon|Tue|Wed|Thu|Fri|Sat|Sun', '3', '0', '0', '0', '99999');

INSERT INTO `export_schemes` (`scheme_id`, `type_id`, `scheme_name`, `filename`, `field_separator`, `field_quotes`, `date_created`, `date_modified`, `date_last_export`, `created_by`, `customers_status_id`, `currencies_id`, `languages_id`, `campaign_id`, `shipping_free_minimum`, `quantity_minimum`, `export_attributes`, `export_properties`, `export_features`, `cronjob_allowed`, `cronjob_days`, `cronjob_hour`, `cronjob_interval`, `export_all_new_ones`, `export_property_image`, `amount_additional_image_files`) VALUES
	(21, 2, '[Gambio] Shopping.com', 'shopping.csv', '|', '"', '2013-07-24 13:50:25', '2017-09-27 10:30:00', '1000-01-01 00:00:00', 'gambio', 1, 1, 2, '0', '0.0000', '0.0000', 0, 0, 0, 0, 'Mon|Tue|Wed|Thu|Fri|Sat|Sun', '3', '0', 0, 0, 99999),
	(22, 2, '[Gambio] Ampify', 'ampify.txt', '\\t', '', '2018-03-14 10:15:32', '2018-03-14 10:15:32', '1000-01-01 00:00:00', 'gambio', 1, 1, 2, '0', '0.0000', '0.0000', 0, 0, 0, 0, 'Mon|Tue|Wed|Thu|Fri|Sat|Sun', '3', '0', 0, 0, 10);

INSERT INTO `export_schemes` (`scheme_id`, `type_id`, `scheme_name`, `filename`, `field_separator`, `field_quotes`, `date_created`, `date_modified`, `date_last_export`, `created_by`, `customers_status_id`, `currencies_id`, `languages_id`, `campaign_id`, `shipping_free_minimum`, `quantity_minimum`, `export_attributes`, `export_properties`, `export_features`, `cronjob_allowed`, `cronjob_days`, `cronjob_hour`, `cronjob_interval`, `export_all_new_ones`, `export_property_image`, `amount_additional_image_files`) VALUES
	(23, 2, '[Gambio] GLMall', 'glmall.csv', ',', '\"', '2020-09-08 11:58:54', '2020-09-11 09:02:36', '2020-09-11 11:01:00', 'gambio', 1, 1, 2, '0', '0.0000', '0.0000', 0, 1, 0, 0, 'Mon|Tue|Wed|Thu|Fri|Sat|Sun', '4', '0', 1, 0, 10);
